define(['angular', 'app', 'page_service'], function (angular, app) {
	'use strict';

	app.controller('AboutController', function ($scope, $modalInstance, $timeout, pageService, focusService) {

		$scope.$watch(function () {
			return $('div.modal-header h3').is(":visible");
		}, function (isVisible, wasVisible) {
			if (isVisible && !wasVisible) {
				focusService.focusElement($('div.modal-header h3'));
			}
		});

		$scope.version = pageService.getVersionNumber();
		$scope.groups = [
			{
				id: 1,
				title: 'VA FitHeart',
				content: 'VA FitHeart is designed to help people with heart conditions improve their heart health by increasing physical fitness and providing tools for a healthy lifestyle. This mobile application is not intended to replace professional medical diagnosis or treatment. The main part of the program is designed to resemble a cardiac rehabilitation program. Typical programs guide people through education and fitness training over 12 weeks.'
			},
			{
				id: 2,
				title: 'Project Team',
				template: 'src/ui-components/modals/about/partials/project-team_template.html'
			},
			{
				id: 3,
				title: 'References',
				template: 'src/ui-components/modals/about/partials/references_template.html'
			},
			{
				id: 4,
				title: 'Acknowledgements',
				template: 'src/ui-components/modals/about/partials/acknowledgements_template.html'
			}
		];

		$scope.ok = function () {
			$modalInstance.close();
		};

		$scope.showEula = function () {
			window.open("src/ui-components/modals/about/eula.html", "_blank", "location=no,scrollbars=1,resizable=1");
		};
	})
});